-------------------------------------------------------------------
-- APELLIDOS: 
-------------------------------------------------------------------
-- NOMBRE:
-------------------------------------------------------------------
-- MAQUINA:
-------------------------------------------------------------------

infixr 5 :>
data Cola a = U a | Cola a :> Cola a deriving Show

-- atencion, :> es asociativo a la derecha
c1 :: Cola Integer  
c1 = U 1 :> U 2 :> U 3

c2 :: Cola Integer   
c2 = (U 5 :> U 7) :> (U 6 :> U 8 :> U 9) 

------------- 
-- APARTADO A
-------------

fusion :: Cola a -> Cola a -> Cola a
fusion = (:>)

listaACola :: [a] -> Cola a
listaACola [x] = U x
listaACola xs = listaACola us :> listaACola us'
	where (us,us') = partir xs

partir xs = splitAt (length xs `div` 2) xs

------------- 
-- APARTADO B
-------------

redCola :: (b -> b -> b) -> (a -> b) -> Cola a -> b 
redCola f g (U x) 	= g x
redCola f g (c :> c') 	= f (redCola f g c) (redCola f g c')

-- la siguiente funcin tambin puede ser til
mapCola :: (a->b) -> Cola a -> Cola b
mapCola h = redCola (:>) (U . h)


-- estudiar el tipo y qu computa la funcin:
-- pamCola :: a -> Cola (a->b) -> Cola b
pamCola  x = redCola (:>) (U.($ x))

 

------------- 
-- APARTADO C
-------------

sumaCola :: Num a => Cola a -> a
sumaCola = redCola (+) id

pertenece :: Eq a => a -> Cola a -> Bool
pertenece x = redCola (||) (==x)


------------- 
-- APARTADO D
-------------


-- representacion de polinomios
type Monomio = (Integer,Double)
type Polinomio = Cola Monomio

unPol = U (3,4.1) :> U(2,-4.1) :> U(4,6.2)

valorEn :: Double -> Polinomio -> Double
valorEn x = redCola (+) (\ (n,c) -> c*x^n)


mulPorMonomio :: Monomio  -> Polinomio -> Polinomio
mulPorMonomio (n,c) = mapCola (\ (n',c') -> (n+n',c*c'))



--------- OTRAS COSAS QUE NO SE PIDEN

-- estudiar que computa la funcin 
cosa  :: Cola a -> Integer
cosa = redCola (+) (\ x -> 1) 


colaAlista :: Cola a -> [a]
colaAlista = redCola (++) (:[])

enCola :: a -> Cola a -> Cola a
enCola z (U x )  = U z :> U x
enCola z (c:>c') = enCola z c :> c'

deCola :: Cola a -> (Cola a, a)
deCola (c :> (U x)) = (c,x)
deCola (c :> c' ) = (c :> c'',x) where (c'',x) = deCola c'

concaCola :: Cola (Cola a) -> Cola a
concaCola = redCola (:>) id


-- si cada grado aparece una sola vez
sumaMonomio :: Monomio -> Polinomio -> Polinomio
sumaMonomio (n,c) (U (n',c'))
 | n==n' 			= U(n,c+c')
 | otherwise			= U(n,c') :> U(n,c)
sumaMonomio (n,c) (p :> p')
 | estaGrado n p                = sumaMonomio (n,c) p :> p'
 | otherwise 			= p :> sumaMonomio (n,c) p'

estaGrado :: Integer -> Polinomio -> Bool
estaGrado n = redCola (||) (\(n',_) -> n==n')
